package gov.va.med.mhv.usermgmt.service;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.springframework.stereotype.Service;

import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.exception.MHVException;

@Path("/")
@Service("patient")
public interface PatientWebService {
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("patient/pid/{patientid}")
	PatientDTO getPatientByPatientId(@PathParam("patientid") Long patientid) throws MHVException;

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("patient/uid/{userProfileId}")
	PatientDTO getPatientByUserProfileId(@PathParam("userProfileId") Long userProfileId) throws MHVException;
	
}
